//%attributes = {}
// Method: pr_ AmountDesign2ToStock1( amount;Unit/Design.Multip;DesignMultip;round
// 2009.02.02-16:40:45 / Arto Kokkila
// © Copyright 2003 Manage Applications
// Purpose: Converts amount from design unit 2 to stock unit 1
// 
// ------------------------------------------------------------
C_REAL:C285($0; $1; $pr_rDesign2Amount; $2; $pr_rMultiplier; $3; $pr_rDesignMultiplier)
C_LONGINT:C283($4; $pr_lRound)  //round value to default decimals
C_REAL:C285($pr_rStock1Amount; $pr_rDesign1Amount)
$pr_rDesign2Amount:=$1
$pr_rDesignMultiplier:=$2
$pr_rMultiplier:=$3
$pr_lRound:=$4
$pr_rStock1Amount:=0

If ($pr_rMultiplier=kGet)  //-10022
	If (_rec Loaded(pr_kTbl)=kFalse)
		_err MESSAGE(_lang Current("Product record is not loaded, conversion multiplier can not be loaded"); Current method name:C684; kTrue)
	Else 
		$pr_rDesignMultiplier:=_fld ValueReal(pr_kDesign_Conversion_Multip)
		$pr_rMultiplier:=_fld ValueReal(pr_kUnit__Design_Unit_Multip)
	End if 
	
	//design2 to design1
	If ($pr_rDesignMultiplier#-1)
		$pr_rDesign1Amount:=$pr_rDesign2Amount*$pr_rDesignMultiplier
	Else 
		If ($pr_rDesign2Amount#0)
			$pr_rDesign1Amount:=1/$pr_rDesign2Amount
		Else 
			$pr_rDesign1Amount:=0
		End if 
	End if 
	
	//design1 to stock1
	If ($pr_rMultiplier#-1)
		$pr_rStock1Amount:=$pr_rDesign1Amount*$pr_rMultiplier
	Else 
		If ($pr_rDesign1Amount#0)
			$pr_rStock1Amount:=1/$pr_rDesign1Amount
		Else 
			$pr_rStock1Amount:=0
		End if 
	End if 
	
	If ($pr_lRound=kTrue)
		$pr_rStock1Amount:=Round:C94($pr_rStock1Amount; <>pr_iPyörMäär)
	End if 
End if 

$0:=$pr_rStock1Amount

